/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.data.DataAccessorIfc;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.FunctionIfc;
import com.ezylang.evalex.parser.ASTNode;
import com.ezylang.evalex.parser.ParseException;
import com.ezylang.evalex.parser.ShuntingYardConverter;
import com.ezylang.evalex.parser.Token;
import com.ezylang.evalex.parser.Tokenizer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;

public class Expression {
    private final ExpressionConfiguration configuration;
    private final String expressionString;
    private final DataAccessorIfc dataAccessor;
    private final Map<String, EvaluationValue> constants = new TreeMap<String, EvaluationValue>(String.CASE_INSENSITIVE_ORDER);
    private ASTNode abstractSyntaxTree;

    public Expression(String expressionString) {
        this(expressionString, ExpressionConfiguration.defaultConfiguration());
    }

    public Expression(String expressionString, ExpressionConfiguration configuration) {
        this.expressionString = expressionString;
        this.configuration = configuration;
        this.dataAccessor = configuration.getDataAccessorSupplier().get();
        this.constants.putAll(configuration.getDefaultConstants());
    }

    public EvaluationValue evaluate() throws EvaluationException, ParseException {
        return this.evaluateSubtree(this.getAbstractSyntaxTree());
    }

    public EvaluationValue evaluateSubtree(ASTNode startNode) throws EvaluationException {
        EvaluationValue result;
        Token token = startNode.getToken();
        switch (token.getType()) {
            case NUMBER_LITERAL: {
                result = EvaluationValue.numberOfString(token.getValue(), this.configuration.getMathContext());
                break;
            }
            case STRING_LITERAL: {
                result = new EvaluationValue(token.getValue());
                break;
            }
            case VARIABLE_OR_CONSTANT: {
                result = this.getVariableOrConstant(token);
                if (!result.isExpressionNode()) break;
                result = this.evaluateSubtree(result.getExpressionNode());
                break;
            }
            case PREFIX_OPERATOR: 
            case POSTFIX_OPERATOR: {
                result = token.getOperatorDefinition().evaluate(this, token, this.evaluateSubtree(startNode.getParameters().get(0)));
                break;
            }
            case INFIX_OPERATOR: {
                result = token.getOperatorDefinition().evaluate(this, token, this.evaluateSubtree(startNode.getParameters().get(0)), this.evaluateSubtree(startNode.getParameters().get(1)));
                break;
            }
            case ARRAY_INDEX: {
                result = this.evaluateArrayIndex(startNode);
                break;
            }
            case STRUCTURE_SEPARATOR: {
                result = this.evaluateStructureSeparator(startNode);
                break;
            }
            case FUNCTION: {
                result = this.evaluateFunction(startNode, token);
                break;
            }
            default: {
                throw new EvaluationException(token, "Unexpected evaluation token: " + token);
            }
        }
        return result.isNumberValue() ? this.roundAndStripZerosIfNeeded(result) : result;
    }

    private EvaluationValue getVariableOrConstant(Token token) throws EvaluationException {
        EvaluationValue result = this.constants.get(token.getValue());
        if (result == null) {
            result = this.getDataAccessor().getData(token.getValue());
        }
        if (result == null) {
            throw new EvaluationException(token, String.format("Variable or constant value for '%s' not found", token.getValue()));
        }
        return result;
    }

    private EvaluationValue evaluateFunction(ASTNode startNode, Token token) throws EvaluationException {
        ArrayList<EvaluationValue> parameterResults = new ArrayList<EvaluationValue>();
        for (int i = 0; i < startNode.getParameters().size(); ++i) {
            if (token.getFunctionDefinition().isParameterLazy(i)) {
                parameterResults.add(new EvaluationValue(startNode.getParameters().get(i)));
                continue;
            }
            parameterResults.add(this.evaluateSubtree(startNode.getParameters().get(i)));
        }
        EvaluationValue[] parameters = parameterResults.toArray(new EvaluationValue[0]);
        FunctionIfc function = token.getFunctionDefinition();
        function.validatePreEvaluation(token, parameters);
        return function.evaluate(this, token, parameters);
    }

    private EvaluationValue evaluateArrayIndex(ASTNode startNode) throws EvaluationException {
        EvaluationValue array = this.evaluateSubtree(startNode.getParameters().get(0));
        EvaluationValue index = this.evaluateSubtree(startNode.getParameters().get(1));
        if (array.isArrayValue() && index.isNumberValue()) {
            return array.getArrayValue().get(index.getNumberValue().intValue());
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation(startNode.getToken());
    }

    private EvaluationValue evaluateStructureSeparator(ASTNode startNode) throws EvaluationException {
        EvaluationValue structure = this.evaluateSubtree(startNode.getParameters().get(0));
        Token nameToken = startNode.getParameters().get(1).getToken();
        String name = nameToken.getValue();
        if (structure.isStructureValue()) {
            if (!structure.getStructureValue().containsKey(name)) {
                throw new EvaluationException(nameToken, String.format("Field '%s' not found in structure", name));
            }
            return structure.getStructureValue().get(name);
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation(startNode.getToken());
    }

    private EvaluationValue roundAndStripZerosIfNeeded(EvaluationValue value) {
        BigDecimal bigDecimal = value.getNumberValue();
        if (this.configuration.getDecimalPlacesRounding() != -1) {
            bigDecimal = bigDecimal.setScale(this.configuration.getDecimalPlacesRounding(), this.configuration.getMathContext().getRoundingMode());
        }
        if (this.configuration.isStripTrailingZeros()) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return new EvaluationValue(bigDecimal);
    }

    public ASTNode getAbstractSyntaxTree() throws ParseException {
        if (this.abstractSyntaxTree == null) {
            Tokenizer tokenizer = new Tokenizer(this.expressionString, this.configuration);
            ShuntingYardConverter converter = new ShuntingYardConverter(this.expressionString, tokenizer.parse(), this.configuration);
            this.abstractSyntaxTree = converter.toAbstractSyntaxTree();
        }
        return this.abstractSyntaxTree;
    }

    public void validate() throws ParseException {
        this.getAbstractSyntaxTree();
    }

    public Expression with(String variable, Object value) {
        if (this.constants.containsKey(variable)) {
            if (this.configuration.isAllowOverwriteConstants()) {
                this.constants.remove(variable);
            } else {
                throw new UnsupportedOperationException(String.format("Can't set value for constant '%s'", variable));
            }
        }
        this.getDataAccessor().setData(variable, new EvaluationValue(value));
        return this;
    }

    public Expression and(String variable, Object value) {
        return this.with(variable, value);
    }

    public Expression withValues(Map<String, ?> values) {
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            this.with(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ASTNode createExpressionNode(String expression) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(expression, this.configuration);
        ShuntingYardConverter converter = new ShuntingYardConverter(expression, tokenizer.parse(), this.configuration);
        return converter.toAbstractSyntaxTree();
    }

    public EvaluationValue convertDoubleValue(double value) {
        return new EvaluationValue(value, this.configuration.getMathContext());
    }

    public List<ASTNode> getAllASTNodes() throws ParseException {
        return this.getAllASTNodesForNode(this.getAbstractSyntaxTree());
    }

    private List<ASTNode> getAllASTNodesForNode(ASTNode node) {
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        nodes.add(node);
        for (ASTNode child : node.getParameters()) {
            nodes.addAll(this.getAllASTNodesForNode(child));
        }
        return nodes;
    }

    public Set<String> getUsedVariables() throws ParseException {
        TreeSet<String> variables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ASTNode node : this.getAllASTNodes()) {
            if (node.getToken().getType() != Token.TokenType.VARIABLE_OR_CONSTANT || this.constants.containsKey(node.getToken().getValue())) continue;
            variables.add(node.getToken().getValue());
        }
        return variables;
    }

    public Set<String> getUndefinedVariables() throws ParseException {
        TreeSet<String> variables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String variable : this.getUsedVariables()) {
            if (this.getDataAccessor().getData(variable) != null) continue;
            variables.add(variable);
        }
        return variables;
    }

    @Generated
    public ExpressionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getExpressionString() {
        return this.expressionString;
    }

    @Generated
    public DataAccessorIfc getDataAccessor() {
        return this.dataAccessor;
    }

    @Generated
    public Map<String, EvaluationValue> getConstants() {
        return this.constants;
    }
}

